// 3108DOBufferDlg.cpp : implementation file
//

#include "stdafx.h"
#include "3108DOBuffer.h"
#include "3108DOBufferDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMy3108DOBufferDlg dialog

CMy3108DOBufferDlg::CMy3108DOBufferDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMy3108DOBufferDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMy3108DOBufferDlg)
	m_status = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMy3108DOBufferDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMy3108DOBufferDlg)
	DDX_Control(pDX, IDC_INIT, m_init);
	DDX_Control(pDX, IDC_START, m_start);
	DDX_Text(pDX, IDC_STATUS, m_status);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMy3108DOBufferDlg, CDialog)
	//{{AFX_MSG_MAP(CMy3108DOBufferDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_INIT, OnInit)
	ON_BN_CLICKED(IDC_START, OnStart)
	ON_BN_CLICKED(IDC_QUIT, OnQuit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMy3108DOBufferDlg message handlers

BOOL CMy3108DOBufferDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	// set our pointers equal to something
	m_pSR=NULL;
	m_driverInstance=NULL;
		
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMy3108DOBufferDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMy3108DOBufferDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CMy3108DOBufferDlg::OnInit() 
{
	// open the driver and initialize the hardware

	m_driverInstance=OpenDriverLINX(m_hWnd,"kpci3108$"); 
	//give driver name to avoid the Open DriverLINX dialog
	// append $ onto end of driver name to suppress Open on fail action

	// register DriverLINX as a message source
	m_DLmsg=RegisterWindowMessage(DL_MESSAGE); //get safe offset for DLinx messages
	

	m_pSR=(DL_ServiceRequest*) new DL_ServiceRequest; //Allocate memory for the service request
	memset(m_pSR,0,sizeof(DL_ServiceRequest)); //Initialize the members of the service request to 0
	DL_SetServiceRequestSize(*m_pSR); //Need to set the size of the service request
	m_pSR->device=0;  // device number assigned in DLinx Config Panel
	m_pSR->operation=INITIALIZE;
	m_pSR->subsystem=DEVICE;  // init the entire board
	m_pSR->mode=OTHER;
	m_pSR->hWnd=m_hWnd; //use the window handle of this application

	if (DriverLINX(m_pSR) == NoErr)  //Execute the service request
	{
		m_start.EnableWindow(TRUE);  // if sucessful init, allow start button
		m_init.EnableWindow(FALSE);  // disable init
	} 
	else
	{
	showMessage(m_pSR); //show errors, if any
	}

	CDialog::SetActiveWindow();  // return focus to our dialog
	
}

void CMy3108DOBufferDlg::showMessage(DL_ServiceRequest *SR)
{
	SR->operation=MESSAGEBOX; //Use a message box to show errors
	DriverLINX(SR); //Execute the service request
	return;
}

void CMy3108DOBufferDlg::clearBuffer()
{
	if(m_pSR!=NULL) //Check to see if a service request exists first
	{
		if(m_pSR->lpBuffers!=NULL) //Check to see if a buffer list has been defined
		{
			if(m_pSR->lpBuffers->BufferAddr[0]!=NULL) 
			{
				BufFree(m_pSR->lpBuffers->BufferAddr[0]); //Free the buffer memory if one exists
				m_pSR->lpBuffers->BufferAddr[0]=NULL;
			}
			delete(m_pSR->lpBuffers); //Clear the buffer list AFTER the buffer itself has been cleared
			m_pSR->lpBuffers=NULL;
		}
	}
}

void CMy3108DOBufferDlg::OnStart() 
{
	// set up a single channel bufferd DO task
	
	/*
	  For the KPCI-3107 or KPCI-3108, there is a dedicated chan 0 of the DO
	  sub-system.  Therefore, there is no need to first configure chan 0 for
	  output direction, it is always availble for output direction.  These are the OPx
	  connections on the upper connector.

	  On the lower connector are 4 more general purpose digital channels.  These
	  channels will initialize as inputs so do require configuration for output
	  direction before they could be used in this task.  If you fail to do this step
	  you will get an invalid channel in channel/gain list error message when
	  attempting to use them as outputs.

	  This example was written in MSVC++ 6 Professional with 3108-850A04
	  and a KPCI-3108 in Win98SE.  The KPCI-3108 had A08FW and Rev D ckt board.

  */
	m_status.Format("%s","Starting the task......");
    UpdateData(FALSE);

	clearBuffer(); //Clear any existing buffers
	m_samples = 100;
	memset(m_pSR,0,sizeof(DL_ServiceRequest));  // reset members of the SR structure
	DL_SetServiceRequestSize(*m_pSR);

	m_pSR->hWnd=m_hWnd;
	m_pSR->device=0;
	m_pSR->operation=START;
	m_pSR->mode=INTERRUPT;   
	m_pSR->subsystem=DO;
	// set up the pacing information
    m_pSR->timing.typeEvent=RATEEVENT; 
	m_pSR->timing.u.rateEvent.channel= DEFAULTTIMER;
	m_pSR->timing.u.rateEvent.clock=INTERNAL1;
	m_pSR->timing.u.rateEvent.mode=RATEGEN;
	m_pSR->timing.u.rateEvent.gate=DISABLED;
	m_pSR->timing.u.rateEvent.period=Sec2Tics(0,DO,INTERNAL1,0.01f); // 100Hz rate
	m_pSR->timing.u.rateEvent.pulses=0;    

	m_pSR->start.typeEvent=COMMAND;  // start when we call DriverLINX()
	m_pSR->stop.typeEvent=TCEVENT;   // stop automatically at end of buffer
	m_pSR->channels.nChannels=1;     // only a start channel will be specified
	m_pSR->channels.chanGain[0].channel=0;  // start on channel 0
   	m_pSR->channels.numberFormat=tNATIVE;

	// allocate our bufferssss
	m_pSR->lpBuffers=(DL_BUFFERLIST*)new BYTE[DL_BufferListBytes(1)]; //Create a list of buffers;  in this case, just one
	m_pSR->lpBuffers->notify=NOTIFY; //Enable the buffer_filled message
	m_pSR->lpBuffers->nBuffers=1; //Only one buffer will be used
	m_pSR->lpBuffers->bufferSize=Samples2Bytes(0,DO,0,m_samples);  
	m_pSR->lpBuffers->BufferAddr[0]=BufAlloc(GBUF_INT,m_pSR->lpBuffers->bufferSize); //Allocate
    
	//load the array with values
	BYTE DigitalBuf[100];  // allocate an array for our digital data
	int i;
	for (i=0;i<m_samples;i++)
	{
		 DigitalBuf[i] = 1 & i;  // toggle
	}

	// could do a convert operation to move the data from 
	// array to memory buffer.....or just point at it 
    m_pSR->lpBuffers->BufferAddr[0] = &DigitalBuf;  // point memory buffer at our data
    
	DriverLINX(m_pSR);
	showMessage(m_pSR);

	m_start.EnableWindow(FALSE);  // don't allow restart until done


}

LRESULT CMy3108DOBufferDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	// this is our message pump.  Here we can detect
	// messages from DriverLINX and respond to them
			if(message==m_DLmsg) //Was a DriverLINX message posted?
	{
		switch(wParam)
		{
		case DL_SERVICEDONE: //Was the Servied Done message posted?
			m_status.Format("%s","Task is complete");
            //UpdateData(FALSE);
			m_start.EnableWindow(TRUE); // all restarts
			break;
	    case DL_BUFFERFILLED: //Was the Buffer Filled message posted?
			m_status.Format("%s","Buffer has been written");
            UpdateData(FALSE);
			break;
		}
	}

	
	return CDialog::WindowProc(message, wParam, lParam);
}

void CMy3108DOBufferDlg::OnQuit() 
{
	// TODO: Add your control notification handler code here
	clearBuffer();  //See the clearBuffer definition for details
	if (m_pSR != NULL)
	{
	delete m_pSR; //De-allocate the memory used by the service request
	m_pSR=NULL;
	}
	if (m_driverInstance != NULL)
	{
	CloseDriverLINX(m_driverInstance); //Close the DriverLINX driver
	m_driverInstance=NULL;
	}
	CDialog::DestroyWindow();  // close us down
}

